<?php

namespace App\Controllers\Admin;

use App\Models\BayarModel;
use App\Models\BiayaPendidikanModel;
use App\Models\CalonSiswaModel;
use App\Models\DiskonModel;
use App\Models\GelombangModel;
use App\Models\JenjangModel;
use App\Models\JurusanModel;
use App\Models\NotifikasiModel;
use App\Models\TahunAjaranModel;
use App\Models\UploadModel;
use App\Models\UsersModel;
use Spipu\Html2Pdf\Html2Pdf;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Pendaftaran extends AdminController
{
    protected $mainModel;
    protected $jenjangModel;
    protected $jurusanModel;
    protected $tahunAjaranModel;
    protected $gelombangModel;
    protected $uploadModel;
    protected $diskonModel;
    protected $bayarModel;
    protected $userModel;
    protected $biayaPendidikanModel;
    protected $notifikasiModel;
    public function __construct()
    {
        $this->mainModel = new CalonSiswaModel();
        $this->jenjangModel = new JenjangModel();
        $this->jurusanModel = new JurusanModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
        $this->uploadModel = new UploadModel();
        $this->diskonModel = new DiskonModel();
        $this->bayarModel = new BayarModel();
        $this->userModel = new UsersModel();
        $this->gelombangModel = new GelombangModel();
        $this->biayaPendidikanModel = new BiayaPendidikanModel();
        $this->notifikasiModel = new NotifikasiModel();
    }

    public function index()
    {

        $this->data['title'] = 'Pendaftaran';
        $this->data['tahun_ajaran_list'] =  $this->tahunAjaranModel->orderBy('active', 'desc')->findAll();
        $this->data['jenjang_list'] =  $this->jenjangModel->gets();
        $this->data['paginate'] = $this->mainModel->paginateData();
        $this->data['pager'] =  $this->data['paginate']['pager'];

        return view('admin/pendaftaran/index', $this->data);
    }


    public function create($jenjang_id = null)
    {

        $this->data['title'] = 'Pendaftaran Baru';
        if (!$jenjang_id) $jenjang_id = 1;
        $this->data['jenjang_active'] =  $this->jenjangModel->gets(['id' => $jenjang_id]);
        $this->data['jenjang_list'] =  $this->jenjangModel->gelombang_active();
        $this->data['jurusan_list'] =  $this->jurusanModel->gets();
        return view('admin/pendaftaran/add', $this->data);
    }

    public function attemptCreate($jenjang_id = null)
    {
        $gelombang = get_gelombang_on(esc($this->request->getPost('jenjang_id')));
        if (!$gelombang) {
            return redirect()->route('admin/pendaftaran/create')->with('error', 'Tidak ada gelombang pendaftaran yang aktif.');
        }

        $newData = [
            // 'no_pendaftaran' => esc($this->request->getPost('no_pendaftaran')),
            'jenis_daftar' => esc($this->request->getPost('jenis_daftar')),
            'gelombang_id' => $gelombang->id,
            'thn_ajaran_id' => $gelombang->thn_ajaran_id,
            'jenjang_id' => esc($this->request->getPost('jenjang_id')),
            'jurusan_id' => esc($this->request->getPost('jurusan_id')),
            'jurusan_id_old' => esc($this->request->getPost('jurusan_id_old')),
            'nama_lengkap' => esc($this->request->getPost('nama_lengkap')),
            'nisn' => esc($this->request->getPost('nisn')),
            'ukuran_seragam' => esc($this->request->getPost('ukuran_seragam')),
            'jk' => esc($this->request->getPost('jk')),
            'tempat_lahir' => esc($this->request->getPost('tempat_lahir')),
            'tanggal_lahir' => esc($this->request->getPost('tanggal_lahir')),
            'nama_panggilan' => esc($this->request->getPost('nama_panggilan')),
            'agama' => esc($this->request->getPost('agama')),
            'anak_ke' => esc($this->request->getPost('anak_ke')),
            'surat_pernyataan' => esc($this->request->getPost('surat_pernyataan')),
            'alamat_peserta' => esc($this->request->getPost('alamat_peserta')),
            'rt' => esc($this->request->getPost('rt')),
            'rw' => esc($this->request->getPost('rw')),
            'kelurahan' => esc($this->request->getPost('kelurahan')),esc($this->request->getPost('kelurahan')),
            'kecamatan' => esc($this->request->getPost('kecamatan')),
            'kab_kota' => esc($this->request->getPost('kab_kota')),
            'nohp' => esc(clean_phone_number($this->request->getPost('nohp'))),
            'berat_badan' => esc($this->request->getPost('berat_badan')),
            'tinggi_badan' => esc($this->request->getPost('tinggi_badan')),
            'golongan_darah' => esc($this->request->getPost('golongan_darah')),
            'asal_smp' => esc($this->request->getPost('asal_smp')),
            'asal_sd' => esc($this->request->getPost('asal_sd')),
            'nama_ayah' => esc($this->request->getPost('nama_ayah')),
            'nama_ibu' => esc($this->request->getPost('nama_ibu')),
            'nama_wali' => esc($this->request->getPost('nama_wali')),
            'ttl_ayah' => esc($this->request->getPost('ttl_ayah')),
            'ttl_ibu' => esc($this->request->getPost('ttl_ibu')),
            'ttl_wali' => esc($this->request->getPost('ttl_wali')),
            'pendidikan_ayah' => esc($this->request->getPost('pendidikan_ayah')),
            'pendidikan_ibu' => esc($this->request->getPost('pendidikan_ibu')),
            'pendidikan_wali' => esc($this->request->getPost('pendidikan_wali')),
            'pekerjaan_ayah' => esc($this->request->getPost('pekerjaan_ayah')),
            'pekerjaan_ibu' => esc($this->request->getPost('pekerjaan_ibu')),
            'pekerjaan_wali' => esc($this->request->getPost('pekerjaan_wali')),
            'penghasilan_ayah' => esc($this->request->getPost('penghasilan_ayah')),
            'penghasilan_ibu' => esc($this->request->getPost('penghasilan_ibu')),
            'penghasilan_wali' => esc($this->request->getPost('penghasilan_wali')),
            'nohp_ayah' => esc($this->request->getPost('nohp_ayah')),
            'nohp_ibu' => esc($this->request->getPost('nohp_ibu')),
            'nohp_wali' => esc($this->request->getPost('nohp_wali')),
            'alamat_ayah' => esc($this->request->getPost('alamat_ayah')),
            'alamat_ibu' => esc($this->request->getPost('alamat_ibu')),
            'alamat_wali' => esc($this->request->getPost('alamat_wali')),
            'status_kelulusan' => esc($this->request->getPost('status_kelulusan')),
            'fc_izajah' => esc($this->request->getPost('fc_izajah')),
            'fc_akte_lahir' => esc($this->request->getPost('fc_akte_lahir')),
            'fc_kk' => esc($this->request->getPost('fc_kk')),
            'fc_ayah_ibu' => esc($this->request->getPost('fc_ayah_ibu')),
            'fc_kip' => esc($this->request->getPost('fc_kip')),
            'pas_photo' => esc($this->request->getPost('pas_photo')),
            // 'biaya_pendidikan'=>esc($this->request->getPost('biaya_pendidikan')),
            // 'diskon'=>esc($this->request->getPost('diskon')),
            'catatan' => esc($this->request->getPost('catatan')),
            // 'total_wajib_bayar' => esc($this->request->getPost('total_wajib_bayar')),
            'referensi_nama' => esc($this->request->getPost('referensi_nama')),
            'referensi_hp' => esc($this->request->getPost('referensi_hp')),
        ];
        $newData['biaya_pendidikan'] = get_biaya_pendidikan($newData['jenjang_id'], $newData['jurusan_id']);
        $newData['biaya_attribut'] = get_biaya_attribut($newData['jenjang_id'], $newData['jurusan_id']);
        $newData['diskon_biaya_pengembangan'] = (int) get_persentase_biaya_pengembangan($newData['jenjang_id'], $newData['jurusan_id']);
        $total_wajib_bayar = $newData['biaya_pendidikan'];
        // $nominal_diskon_gelombang = get_gelombang_on($newData['jenjang_id']) ? ($total_wajib_bayar * \get_gelombang_on($newData['jenjang_id'])->persentase / 100) : $total_wajib_bayar;
        // $newData['diskon_gelombang'] = $nominal_diskon_gelombang;
        // $newData['total_wajib_bayar'] = $total_wajib_bayar -  $newData['diskon_gelombang'];
        if ($this->userModel->is_unique_username(\clean_phone_number($newData['nohp'])) == false) {
            return redirect()->back()->withInput()->with('error', 'No Handphone sudah pernah terpakai.');
        }
        $newData['total_wajib_bayar'] = $total_wajib_bayar;
        $newData['total_sisa_bayar'] = $newData['total_wajib_bayar'];
        $newData['fc_izajah_file'] = $this->uploadModel->upload_lampiran('fc_izajah_file');
        
if ($newData['fc_izajah_file']) {
    $newData['fc_izajah'] = 1; // Set fc_kip menjadi 1 jika upload berhasil
}

        $newData['fc_akte_lahir_file'] = $this->uploadModel->upload_lampiran('fc_akte_lahir_file');
        
if ($newData['fc_akte_lahir_file']) {
    $newData['fc_akte_lahir'] = 1;
}

        $newData['fc_kk_file'] = $this->uploadModel->upload_lampiran('fc_kk_file');

if ($newData['fc_kk_file']) {
     $newData['fc_kk'] = 1;
}

        $newData['fc_ayah_ibu_file'] = $this->uploadModel->upload_lampiran('fc_ayah_ibu_file');

if ($newData['fc_ayah_ibu_file']) {
     $newData['fc_ayah_ibu'] = 1;
}

        $newData['fc_kip_file'] = $this->uploadModel->upload_lampiran('fc_kip_file');
        
if ($newData['fc_kip_file']) {
     $newData['fc_kip'] = 1;
}

        $newData['pas_photo_file'] = $this->uploadModel->upload_lampiran('pas_photo_file');

if ($newData['pas_photo_file']) {
     $newData['pas_photo'] = 1;
}


        
        $this->db->transBegin();
        if (!$action = $this->mainModel->create($newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        } else {
            // \insert_notifikasi_daftar($action, $newData['jenjang_id']);
            $this->data['username'] = $newData['nohp'];
            $this->data['password'] = '123456';
            $user_id = $this->userModel->add_user_siswa(['nama_lengkap' => $newData['nama_lengkap'], 'nohp' => $newData['nohp'], 'password' => '123456']);
            if ($user_id) {
                $this->mainModel->edit($action, ['user_id' => $user_id]);
            }
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            return redirect()->route('admin/pendaftaran')->with('success', 'Pendaftaran peserta berhasil.');
        }
    }

    public function edit($uuid = null)
    {
        if (!$doc = $this->mainModel->gets(['id' => $uuid])) {
            $this->session->setFlashData('error', trans("msg_error"));
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $this->notifikasiModel->where('to_id', $this->session->get('vr_sess_user_id'))->where('doc_id', $uuid)->where('read', 0)->set('read', 1)->update();

        $this->data['title'] = $doc->no_pendaftaran;
        $this->data['jenjang_active'] =  $this->jenjangModel->gets(['id' => $doc->jenjang_id]);
        $this->data['jenjang_list'] =  $this->jenjangModel->gelombang_active();
        $this->data['jurusan_list'] =  $this->jurusanModel->gets();
        $this->data['diskon_list'] =  $this->diskonModel->gets(['jenjang_id' => $doc->jenjang_id, 'jurusan_id' => $doc->jurusan_id]);
        $this->data['doc'] = $doc;
        $this->data['bayar_list'] = $this->bayarModel->gets(['calon_siswa_id' => $doc->id]);
        $this->data['diskon_gelombang'] = (int)  \get_persentase_biaya_pengembangan($doc->jenjang_id, $doc->jurusan_id);
        // $this->data['diskon_gelombang_persentase'] = $doc->diskon_persentase_biaya_pengembangan;
        $this->data['tmp_total'] = ($doc->total_sisa_bayar);
        // $this->data['tmp_total'] = ($doc->total_sisa_bayar) * (get_gelombang_on($doc->jenjang_id)->persentase / 100) + $doc->nominal_diskon;

        $this->data['btn_add_bayar'] = ($doc->status_lunas == 1 || get_aktiv_bayar($doc->id) > 0) ? false : true;

        return view('admin/pendaftaran/edit', $this->data);
    }

    public function attemptEdit($uuid = null)
    {
        if (!$doc = $this->mainModel->gets(['id' => $uuid])) {
            $this->session->setFlashData('error', trans("msg_error"));
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $newData = [
            // 'no_pendaftaran' => esc($this->request->getPost('no_pendaftaran')),
            'jenis_daftar' => esc($this->request->getPost('jenis_daftar')),
            // 'gelombang_id' => $doc->gelombang_id,
            // 'jenjang_id' => esc($this->request->getPost('jenjang_id')),
            'jurusan_id' => esc($this->request->getPost('jurusan_id')),
            'jurusan_id_old' => esc($this->request->getPost('jurusan_id_old')),
            'nama_lengkap' => esc($this->request->getPost('nama_lengkap')),
            'nisn' => esc($this->request->getPost('nisn')),
            'ukuran_seragam' => esc($this->request->getPost('ukuran_seragam')),
            'jk' => esc($this->request->getPost('jk')),
            'tempat_lahir' => esc($this->request->getPost('tempat_lahir')),
            'tanggal_lahir' => esc($this->request->getPost('tanggal_lahir')),
            'nama_panggilan' => esc($this->request->getPost('nama_panggilan')),
            'agama' => esc($this->request->getPost('agama')),
            'anak_ke' => esc($this->request->getPost('anak_ke')),
            'surat_pernyataan' => esc($this->request->getPost(('surat_pernyataan'))),
            'alamat_peserta' => esc($this->request->getPost('alamat_peserta')),
            'rt' => esc($this->request->getPost('rt')),
            'rw' => esc($this->request->getPost('rw')),
            'kelurahan' => esc($this->request->getPost('kelurahan')),
            'kecamatan' => esc($this->request->getPost('kecamatan')),
            'kab_kota' => esc($this->request->getPost('kab_kota')),
            'nohp' => esc(clean_phone_number($this->request->getPost('nohp'))),
            'berat_badan' => esc($this->request->getPost('berat_badan')),
            'tinggi_badan' => esc($this->request->getPost('tinggi_badan')),
            'golongan_darah' => esc($this->request->getPost('golongan_darah')),
            'asal_smp' => esc($this->request->getPost('asal_smp')),
            'asal_sd' => esc($this->request->getPost('asal_sd')),
            'nama_ayah' => esc($this->request->getPost('nama_ayah')),
            'nama_ibu' => esc($this->request->getPost('nama_ibu')),
            'nama_wali' => esc($this->request->getPost('nama_wali')),
            'ttl_ayah' => esc($this->request->getPost('ttl_ayah')),
            'ttl_ibu' => esc($this->request->getPost('ttl_ibu')),
            'ttl_wali' => esc($this->request->getPost('ttl_wali')),
            'pendidikan_ayah' => esc($this->request->getPost('pendidikan_ayah')),
            'pendidikan_ibu' => esc($this->request->getPost('pendidikan_ibu')),
            'pendidikan_wali' => esc($this->request->getPost('pendidikan_wali')),
            'pekerjaan_ayah' => esc($this->request->getPost('pekerjaan_ayah')),
            'pekerjaan_ibu' => esc($this->request->getPost('pekerjaan_ibu')),
            'pekerjaan_wali' => esc($this->request->getPost('pekerjaan_wali')),
            'penghasilan_ayah' => esc($this->request->getPost('penghasilan_ayah')),
            'penghasilan_ibu' => esc($this->request->getPost('penghasilan_ibu')),
            'penghasilan_wali' => esc($this->request->getPost('penghasilan_wali')),
            'nohp_ayah' => esc($this->request->getPost('nohp_ayah')),
            'nohp_ibu' => esc($this->request->getPost('nohp_ibu')),
            'nohp_wali' => esc($this->request->getPost('nohp_wali')),
            'alamat_ayah' => esc($this->request->getPost('alamat_ayah')),
            'alamat_ibu' => esc($this->request->getPost('alamat_ibu')),
            'alamat_wali' => esc($this->request->getPost('alamat_wali')),
            'status_kelulusan' => esc($this->request->getPost('status_kelulusan')),
            'fc_izajah' => esc($this->request->getPost('fc_izajah')),
            'fc_akte_lahir' => esc($this->request->getPost('fc_akte_lahir')),
            'fc_kk' => esc($this->request->getPost('fc_kk')),
            'fc_ayah_ibu' => esc($this->request->getPost('fc_ayah_ibu')),
            'fc_kip' => esc($this->request->getPost('fc_kip')),
            'pas_photo' => esc($this->request->getPost('pas_photo')),
            // 'biaya_pendidikan'=>esc($this->request->getPost('biaya_pendidikan')),
            // 'diskon'=>esc($this->request->getPost('diskon')),
            'catatan' => esc($this->request->getPost('catatan')),
            // 'total_wajib_bayar' => esc($this->request->getPost('total_wajib_bayar')),
            'referensi_nama' => esc($this->request->getPost('referensi_nama')),
            'referensi_hp' => esc($this->request->getPost('referensi_hp')),
        ];

        if (!$newData['fc_izajah_file'] = $this->uploadModel->upload_lampiran('fc_izajah_file')) {
            $newData['fc_izajah_file'] = $doc->fc_izajah_file;
        }
   
if ($newData['fc_izajah_file']) {
    $newData['fc_izajah'] = 1; // Set fc_kip menjadi 1 jika upload berhasil
}

        if (!$newData['fc_akte_lahir_file'] = $this->uploadModel->upload_lampiran('fc_akte_lahir_file')) {
            $newData['fc_akte_lahir_file'] = $doc->fc_akte_lahir_file;
        }
if ($newData['fc_akte_lahir_file']) {
    $newData['fc_akte_lahir'] = 1;
}

        if (!$newData['fc_kk_file'] = $this->uploadModel->upload_lampiran('fc_kk_file')) {
            $newData['fc_kk_file'] = $doc->fc_kk_file;
        }
if ($newData['fc_kk_file']) {
     $newData['fc_kk'] = 1;
}

        if (!$newData['fc_ayah_ibu_file'] = $this->uploadModel->upload_lampiran('fc_ayah_ibu_file')) {
            $newData['fc_ayah_ibu_file'] = $doc->fc_ayah_ibu_file;
        }
if ($newData['fc_ayah_ibu_file']) {
     $newData['fc_ayah_ibu'] = 1;
}

        if (!$newData['fc_kip_file'] = $this->uploadModel->upload_lampiran('fc_kip_file')) {
            $newData['fc_kip_file'] = $doc->fc_kip_file;
        }
if ($newData['fc_kip_file']) {
     $newData['fc_kip'] = 1;
}

        if (!$newData['pas_photo_file'] = $this->uploadModel->upload_lampiran('pas_photo_file')) {
            $newData['pas_photo_file'] = $doc->pas_photo_file;
        }
if ($newData['pas_photo_file']) {
     $newData['pas_photo'] = 1;
}
        if (!$newData['surat_pernyataan_file'] = $this->uploadModel->upload_lampiran('surat_pernyataan_file')) {
            $newData['surat_pernyataan_file'] = $doc->surat_pernyataan_file;
        }
if ($newData['surat_pernyataan_file']) {
       $newData['surat_pernyataan'] = 1;
}
        $this->db->transBegin();

        if (!$action = $this->mainModel->edit($doc->id, $newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('success', trans("msg_updated"));
        }
    }

    public function attemptDelete()
    {
        $this->db->transBegin();
        $ids = $this->request->getPost('ids');
        foreach ($ids as $id) {
            if ($doc = $this->mainModel->gets(['id' => $id])) {
                if (!$action = $this->mainModel->remove($doc->id)) {
                    $this->errors = array_merge($this->errors, $this->mainModel->errors());
                } else {
                    $this->userModel->delete_user($doc->user_id);
                }
            }
        }
        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            $this->session->setFlashData('success', trans("msg_suc_deleted"));
            return redirect()->to('admin/pendaftaran')->with('success', trans("msg_suc_deleted"));
        }
    }

    public function batal()
    {
        if (!$doc = $this->mainModel->gets(['id' => $this->request->getPost('id')])) {
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $newData['status_batal'] = 1;
        $newData['alasan_batal'] = esc($this->request->getPost('alasan_batal'));
        if ($doc->total_sudah_bayar >= 1000000) {
            $newData['total_pengembalian_batal'] = $doc->total_sudah_bayar * 0.5;
        }
        $this->db->transBegin();
        if (!$action = $this->mainModel->edit($doc->id, $newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();

            $this->session->setFlashData('success', 'Pembatalan calon siswa berhasil..');
            return redirect()->to('admin/pendaftaran');
        }
    }


    public function ganti_jurusan()
    {
        if (!$doc = $this->mainModel->gets(['id' => $this->request->getPost('id')])) {
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $this->db->transBegin();
        $newData['jurusan_id'] = \only_num(esc($this->request->getPost('jurusan_id')));
        $newData['jurusan_id_old'] = $doc->jurusan_id;
        $jurusanBaru = $this->jurusanModel->where('id', $newData['jurusan_id'])->first();
        $jurusanLama = $this->jurusanModel->where('id', $newData['jurusan_id_old'])->first();
        $newData['catatan_kelebihan_bayar'] = 'PINDAH KE ' . $jurusanBaru->kode . ' dari ' . $jurusanLama->kode;
        $newBiayaPendidikan = \get_biaya_pendidikan($doc->jenjang_id, $newData['jurusan_id']);
        $newBiayaAttribut = \get_biaya_attribut($doc->jenjang_id, $newData['jurusan_id']);
        // $newData['diskon_persentase_biaya_pengembangan'] = get_persentase_biaya_pengembangan($doc->jenjang_id, $newData['jurusan_id']);
        $newData['diskon_biaya_pengembangan'] =  (int) get_persentase_biaya_pengembangan($doc->jenjang_id, $newData['jurusan_id']);
        $getDiskon = !$doc->diskon_id ? null : $this->diskonModel->where('jenjang_id', $doc->jenjang_id)->where('jurusan_id', $newData['jurusan_id'])->first();
        $newData['diskon_id'] = $getDiskon ? $getDiskon->id : null;
        $newData['nominal_diskon'] = $getDiskon ? ($getDiskon->diskon) : 0;
        $newData['biaya_pendidikan'] = $newBiayaPendidikan;
        $newData['biaya_attribut'] = $newBiayaAttribut;
        $newData['total_wajib_bayar'] = $newData['biaya_pendidikan'];
        //recalculate
        // print_r($newData);
        //exit;
        $list_bayar = $this->bayarModel->gets(['calon_siswa_id' => $this->request->getPost('id')]);
        $total_sisa_bayar = $newData['biaya_pendidikan'];
        $total_sudah_bayar = 0;
        if ($list_bayar) {
            $sisa_bayar = $total_sisa_bayar;
            foreach ($list_bayar as $index => $bayar) {
                $wajib_bayar = $sisa_bayar;
                $bayarData = [
                    'gelombang_diskon' => $bayar->gelombang_diskon ?  $newData['diskon_biaya_pengembangan'] : 0,
                    'current_diskon' => $bayar->current_diskon ? $newData['nominal_diskon'] : 0,
                    'wajib_bayar' => $wajib_bayar,
                    'nominal' => $bayar->nominal,
                ];
                $bayarData['sisa_bayar'] = $bayarData['wajib_bayar'] - ($bayarData['nominal'] + $bayarData['gelombang_diskon'] + $bayarData['current_diskon']);
                if ($bayarData['sisa_bayar'] < 0) {
                    $bayarData['sisa_bayar'] = 0;
                }
                if ($bayar->status_bayar_angsuran == 1) {
                    $total_sisa_bayar -= ($bayarData['nominal'] + $bayarData['gelombang_diskon'] + $bayarData['current_diskon']);
                    $total_sudah_bayar += ($bayarData['nominal']);
                }
                $sisa_bayar  = $bayarData['sisa_bayar'];
                if (!$action = $this->bayarModel->edit($bayar->id, $bayarData)) {
                    $this->errors = array_merge($this->errors, $this->mainModel->errors());
                }
            }
        }
        $newData['total_sisa_bayar'] = $total_sisa_bayar < 0 ? 0 : $total_sisa_bayar;
        $newData['total_sudah_bayar'] = $total_sudah_bayar;
        $newData['status_lunas'] = $doc->status_lunas;
        if ($newData['status_lunas'] == 1) {
            $tmpTotalBayar = ($newBiayaPendidikan - $newData['nominal_diskon'] - $newData['diskon_biaya_pengembangan']);
            $kelebihan_kekurangan = $tmpTotalBayar - $newData['total_sudah_bayar'];
            if ($kelebihan_kekurangan > 0) {
                $newData['kelebihan_bayar']  = $kelebihan_kekurangan * -1;
                $newData['status_lunas'] = 0;
                $newData['kelas_id'] = null;
            } else {
                $newData['kelebihan_bayar']  = $kelebihan_kekurangan * -1;
                $newData['total_sudah_bayar']  = $newData['total_sudah_bayar'] - $newData['kelebihan_bayar'];
            }
        }

        if ($newData['jurusan_id'] == $newData['jurusan_id_old']) {
            $this->session->setFlashData('error', 'Jurusan baru harus berbeda dengan yang sekarang.');
            return redirect()->to('admin/pendaftaran')->with('error', 'Jurusan baru harus berbeda dengan yang sekarang.');
        }
        if ($newData['status_lunas'] == 1) {
            $newData['kelas_id'] = map_kelas($doc->jenjang_id, $newData['jurusan_id']);
            if (!$newData['kelas_id']) {
                $this->session->setFlashData('error', 'Tidak bisa melakukan perpindahan jurusan, dikarenakan tidak bisa mapping kelas.');
                return redirect()->to('admin/pendaftaran')->with('error', 'Tidak bisa melakukan perpindahan jurusan, dikarenakan tidak bisa mapping kelas.');
            }
        }
        if (!$action = $this->mainModel->edit($doc->id, $newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            $this->session->setFlashData('success', 'Penggantian jurusan calon siswa berhasil.');
            return redirect()->to('admin/pendaftaran/edit/' . $doc->id)->with('success', 'Penggantian jurusan calon siswa berhasil.');
        }
    }



    public function ganti_program_smp()
    {
        if (!$doc = $this->mainModel->gets(['id' => $this->request->getPost('id')])) {
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $newData['jenjang_id'] = \only_num(esc($this->request->getPost('jenjang_id')));
        $newData['jenjang_id_old'] = $doc->jenjang_id;
        $jenjangBaru = $this->jenjangModel->where('id', $newData['jenjang_id'])->first();
        $jenjangLama = $this->jenjangModel->where('id', $newData['jenjang_id_old'])->first();
        $newData['catatan_kelebihan_bayar'] = 'PINDAH KE ' . $jenjangBaru->nama_jenjang . ' dari ' . $jenjangLama->nama_jenjang;
        $newBiayaPendidikan = \get_biaya_pendidikan($newData['jenjang_id']);
        $newBiayaAttribut = \get_biaya_attribut($newData['jenjang_id']);
        $newData['diskon_biaya_pengembangan'] = (int)  get_persentase_biaya_pengembangan($newData['jenjang_id']);
        $getDiskon = !$doc->diskon_id ? null : $this->diskonModel->where('jenjang_id', $doc->jenjang_id)->first();
        $newData['diskon_id'] = $getDiskon ? $getDiskon->id : null;
        $newData['nominal_diskon'] = $getDiskon ? ($getDiskon->diskon) : 0;
        $newData['biaya_pendidikan'] = $newBiayaPendidikan;
        $newData['biaya_attribut'] = $newBiayaAttribut;
        $newData['total_wajib_bayar'] = $newData['biaya_pendidikan'];
        //recalculate
        $list_bayar = $this->bayarModel->gets(['calon_siswa_id' => $this->request->getPost('id')]);
        $total_sisa_bayar = $newData['biaya_pendidikan'];
        $total_sudah_bayar = 0;
        if ($list_bayar) {
            $sisa_bayar = $total_sisa_bayar;
            foreach ($list_bayar as $index => $bayar) {
                $wajib_bayar = $sisa_bayar;
                $bayarData = [
                    'gelombang_diskon' => $bayar->gelombang_diskon ?  $newData['diskon_biaya_pengembangan'] : 0,
                    'current_diskon' => $bayar->current_diskon ? $newData['nominal_diskon'] : 0,
                    'wajib_bayar' => $wajib_bayar,
                    'nominal' => $bayar->nominal,
                ];
                $bayarData['sisa_bayar'] = $bayarData['wajib_bayar'] - ($bayarData['nominal'] + $bayarData['gelombang_diskon'] + $bayarData['current_diskon']);
                if ($bayarData['sisa_bayar'] < 0) {
                    $bayarData['sisa_bayar'] = 0;
                }
                if ($bayar->status_bayar_angsuran == 1) {
                    $total_sisa_bayar -= ($bayarData['nominal'] + $bayarData['gelombang_diskon'] + $bayarData['current_diskon']);
                    $total_sudah_bayar += ($bayarData['nominal']);
                }
                $sisa_bayar  = $bayarData['sisa_bayar'];
                if (!$action = $this->bayarModel->edit($bayar->id, $bayarData)) {
                    $this->errors = array_merge($this->errors, $this->mainModel->errors());
                }
            }
        }
        $newData['total_sisa_bayar'] = $total_sisa_bayar < 0 ? 0 : $total_sisa_bayar;
        $newData['total_sudah_bayar'] = $total_sudah_bayar;
        $newData['status_lunas'] = $doc->status_lunas;
        if ($newData['status_lunas'] == 1) {
            $tmpTotalBayar = ($newBiayaPendidikan - $newData['nominal_diskon'] - $newData['diskon_biaya_pengembangan']);
            $kelebihan_kekurangan = $tmpTotalBayar - $newData['total_sudah_bayar'];
            if ($kelebihan_kekurangan > 0) {
                $newData['kelebihan_bayar']  = $kelebihan_kekurangan * -1;
                $newData['status_lunas'] = 0;
                $newData['kelas_id'] = null;
            } else {
                $newData['kelebihan_bayar']  = $kelebihan_kekurangan * -1;
                $newData['total_sudah_bayar']  = $newData['total_sudah_bayar'] - $newData['kelebihan_bayar'];
            }
        }

        if ($newData['jenjang_id'] == $newData['jenjang_id_old']) {
            $this->session->setFlashData('error', 'Program baru harus berbeda dengan yang sekarang.');
            return redirect()->to('admin/pendaftaran');
        }
        if ($newData['status_lunas'] == 1) {
            $newData['kelas_id'] = map_kelas($doc->jenjang_id);
            if (!$newData['kelas_id']) {
                $this->session->setFlashData('error', 'Tidak bisa melakukan perpindahan jurusan, dikarenakan tidak bisa mapping kelas.');
                return redirect()->to('admin/pendaftaran');
            }
        }

        $this->db->transBegin();


        if (!$action = $this->mainModel->edit($doc->id, $newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            $this->session->setFlashData('success', 'Penggantian program calon siswa berhasil.');
            return redirect()->to('admin/pendaftaran/edit/' . $doc->id)->with('success', 'Penggantian program calon siswa berhasil.');
        }
    }
    public function update_diskon($uuid = null)
    {
        if (!$doc = $this->mainModel->gets(['id' => $uuid])) {
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('error', trans("msg_error"));
        }

        $getDiskon = $this->diskonModel->where('id', esc($this->request->getPost('diskon_id')))->first();
        $newData = [
            'nominal_diskon' => $getDiskon ? $getDiskon->diskon : 0,
        ];
        $newData['diskon_id'] = \only_num($this->request->getPost('diskon_id'));
        $newData['kelebihan_bayar'] = \only_num($this->request->getPost('kelebihan_bayar'));
        $newData['catatan_kelebihan_bayar'] = esc($this->request->getPost('catatan_kelebihan_bayar'));
        // $newData['sisa_bayar'] = $doc->total_sisa_bayar;
        $this->db->transBegin();
        if (!$action = $this->mainModel->edit($doc->id, $newData)) {
            $this->errors = array_merge($this->errors, $this->mainModel->errors());
        }
        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('success', trans("msg_updated"));
        }
    }
    public function cetak_kwitansi($uuid = null)
    {
        if (!$doc = $this->bayarModel->gets(['id' => $uuid])) {
            $this->session->setFlashData('error', trans("msg_error"));
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $content = view('admin/pendaftaran/kwitansi', ['peserta' => $this->mainModel->gets(['id' => $doc->calon_siswa_id]), 'siswa_bayar' => $doc]);
        $html2pdf = new Html2Pdf('P', 'A4', 'fr', true);
        $html2pdf->pdf->SetDisplayMode('fullpage');
        $html2pdf->writeHTML($content);
        $html2pdf->output($doc->no_pendaftaran . '-' . $doc->angsuranke . '.pdf', 'I');
        exit;
    }
    public function add_bayar($uuid = null)
    {
        if (esc($this->request->getPost('id'))) {
            return $this->edit_bayar();
        }

        if (!$doc = $this->mainModel->gets(['id' => $uuid])) {
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('error', trans("msg_error"));
        }
        $getDiskon = $this->diskonModel->find(esc($this->request->getPost('diskon_id')));
        $newData = [
            'calon_siswa_id' => $uuid,
            'keterangan_bayar' => esc($this->request->getPost('keterangan_bayar')),
            'tipe_bayar' => esc($this->request->getPost('tipe_bayar')),
            'nominal' => esc(\only_num($this->request->getPost('nominal'))),
            'tanggal_bayar' => esc($this->request->getPost('tanggal_bayar')),
        ];
        $newData['wajib_bayar'] = $doc->total_sisa_bayar;
        $angsurang_ke = $this->bayarModel->get_num_angsuran($uuid);
        $newData['angsuranke'] = $this->bayarModel->get_num_angsuran($uuid);
        if ($angsurang_ke == 1) {
            $newData['gelombang_diskon'] = esc(\only_num($this->request->getPost('gelombang_diskon')));
            $newData['current_diskon'] = ($getDiskon ? $getDiskon->diskon : 0);
            $newData['sisa_bayar'] = $doc->total_sisa_bayar - $newData['nominal'] - $newData['gelombang_diskon'] - $newData['current_diskon'];
        } else {
           $newData['current_diskon'] = ($getDiskon ? $getDiskon->diskon : 0);
            $newData['sisa_bayar'] = $doc->total_sisa_bayar - $newData['nominal'] - $newData['current_diskon'];
        }

        /*
        if ($newData['nominal'] > $doc->total_sisa_bayar) {
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('error', 'Nominal melebihi sisa bayar.');
        }
        if ($newData['nominal'] < $doc->total_sisa_bayar && $newData['keterangan_bayar'] == 'Pelunasan') {
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('error', 'Nominal kurang dari total wajib bayar.');
        }
        */


        if ($newData['tipe_bayar'] == 'Transfer') {
            $newData['bukti_bayar'] = $this->uploadModel->upload_lampiran('bukti_bayar');
            $newData['atas_nama'] = esc($this->request->getPost('atas_nama'));
            $newData['bank'] = esc($this->request->getPost('bank'));
        }
        $newData['status_bayar_angsuran'] = esc($this->request->getPost('status_bayar_angsuran'));

        if (is_admin() || is_keuangan()) {
            if ($newData['status_bayar_angsuran'] == 1) $newData['approved_by'] = user()->id;
        }
        $this->db->transBegin();

        if (!$action = $this->bayarModel->create($newData)) {
            $this->errors = array_merge($this->errors, $this->bayarModel->errors());
        } else {
            insert_notifikasi_bayar($doc->id);
            if (esc($this->request->getPost('diskon_id'))) {
                $doc = $this->mainModel->find($uuid);
                $parentData['diskon_id'] = esc($this->request->getPost('diskon_id'));
                if ($parentData['diskon_id']) $parentData['nominal_diskon'] = ($getDiskon ? $getDiskon->diskon : 0);
                $this->mainModel->edit($uuid, $parentData);
            }
        }
        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors_form', $this->errors);
        } else {
            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran/edit/' . $uuid)->with('success', 'Data pembayaran berhasil di tambahkan.');
        }
    }


    public function edit_bayar()
    {
        $id = esc($this->request->getVar('id'));

        if (!$doc = $this->bayarModel->gets(['id' => $id])) {
            $this->session->setFlashData('error', trans("msg_error"));
            return redirect()->to('admin/pendaftaran/edit/' . $doc->calon_siswa_id)->with('error', trans("msg_error"));
        }
        $getDiskon = $this->diskonModel->find(esc($this->request->getPost('diskon_id')));
        $newData = [];
        $newData['status_bayar_angsuran'] = esc($this->request->getPost('status_bayar_angsuran'));
        if (is_fo() || \is_fo_smp()) {
            $newData = [
                'keterangan_bayar' => esc($this->request->getPost('keterangan_bayar')),
                'tipe_bayar' => esc($this->request->getPost('tipe_bayar')),
                'gelombang_diskon' => esc(\only_num($this->request->getPost('gelombang_diskon'))),
                'tanggal_bayar' => esc($this->request->getPost('tanggal_bayar')),
                'current_diskon' => ($getDiskon ? $getDiskon->diskon : 0)
            ];
            if ($newData['tipe_bayar'] == 'Transfer') {
                if (!$newData['bukti_bayar'] = $this->uploadModel->upload_lampiran('bukti_bayar')) {
                    $newData['bukti_bayar'] = $doc->bukti_bayar;
                }
                $newData['atas_nama'] = esc($this->request->getPost('atas_nama'));
                $newData['bank'] = esc($this->request->getPost('bank'));
            }
        }
        if (is_admin() || is_keuangan()) {
            if ($newData['status_bayar_angsuran'] == 1) $newData['approved_by'] = user()->id;
        }

        $this->db->transBegin();
        if (!$action = $this->bayarModel->edit($id, $newData)) {
            $this->errors = array_merge($this->errors, $this->bayarModel->errors());
        } else {
            if ((\is_admin() || \is_keuangan() && $newData['status_bayar_angsuran'] == 1)) {
                $parentData = [
                    'total_sudah_bayar' => $doc->total_sudah_bayar + $doc->nominal,
                    'total_sisa_bayar' => $doc->sisa_bayar,
                ];
                if ((int) $parentData['total_sisa_bayar'] == 0) {
                    $parentData['status_lunas'] = 1;
                    $parentData['kelas_id'] = map_kelas($doc->jenjang_id, $doc->jurusan_id);
                }
                $this->mainModel->edit($doc->calon_siswa_id, $parentData);
            }
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran/edit/' . $doc->calon_siswa_id)->with('success', trans("msg_updated"));
        }
    }
    public function removeBayar()
    {
        $id = $this->request->getPost('id');
        if (!$doc = $this->bayarModel->gets(['id' => $id])) {
            return redirect()->route('admin/pendaftaran')->with('error', trans("msg_error"));
        }
        $this->db->transBegin();
        if (!$action = $this->bayarModel->remove($doc->id)) {
            $this->errors = array_merge($this->errors, $this->bayarModel->errors());
        }

        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
            return redirect()->back()->withInput()->with('errors', $this->errors);
        } else {
            if ($doc->status_bayar_angsuran == 1) {
                $this->mainModel->where('id', $doc->calon_siswa_id);
                $this->mainModel->set('total_sudah_bayar', $doc->total_sudah_bayar - $doc->nominal);
                $this->mainModel->set('total_sisa_bayar', $doc->total_sisa_bayar + $doc->nominal + $doc->gelombang_diskon + $doc->current_diskon);
                if ($doc->keterangan_bayar == 'Pelunasan') {
                    $this->mainModel->set('kelas_id', null);
                    $this->mainModel->set('status_lunas', 0);
                }
                $this->mainModel->update();
            }

            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran/edit/' . $doc->calon_siswa_id)->with('success', trans("msg_suc_deleted"));
        }
    }
    function import_kelulusan()
    {
        $this->data['title'] = 'Import Data Peserta Lulus';
        return view('admin/pendaftaran/import', $this->data);
    }
    function import_kelulusan_post()
    {

        $file_excel = $this->request->getFile('file_daftar');
        $ext = $file_excel->getClientExtension();
        if ($ext == 'xls') {
            $render = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        } else {
            $render = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        }
        $spreadsheet = $render->load($file_excel);
        $data = $spreadsheet->getActiveSheet()->toArray();
        $this->db->transBegin();
        foreach ($data as $x => $row) {
            if ($x == 0) {
                continue;
            }
            $no_pendaftaran = $row[0];
            $nama_lengkap = $row[1];
            $status = $row[2];

            $cek = $this->mainModel->where('no_pendaftaran', $no_pendaftaran)->first();
            if ($cek) {
                $newData['status_kelulusan'] = $status;
                if (!$action = $this->mainModel->edit($cek->id, $newData)) {
                    $this->errors = array_merge($this->errors, $this->mainModel->errors());
                }
            }
        }
        if ($this->db->transStatus() === false || count($this->errors) > 0) {
            $this->db->transRollback();
        } else {
            $this->db->transCommit();
            return redirect()->to('admin/pendaftaran')->with('success', 'Import data berhasil.');
        }
    }
    function export_data()
    {
        $dataModel = $this->mainModel->gets($_GET);
        $spreadsheet = new Spreadsheet();
        // tulis header/nama kolom 
        $spreadsheet->setActiveSheetIndex(0)
            ->setCellValue('A1', 'No Pendaftaran')
            ->setCellValue('B1', 'Gelombang')
            ->setCellValue('C1', 'Nama Lengkap')
            ->setCellValue('D1', 'Nama Panggilan')
            ->setCellValue('E1', 'No Handphone')
            ->setCellValue('F1', 'NISN')
            ->setCellValue('G1', 'Jenis Kelamin')
            ->setCellValue('H1', 'Agama')
            ->setCellValue('I1', 'Tempat Lahir')
            ->setCellValue('J1', 'Tanggal Lahir')
            ->setCellValue('K1', 'Anak Ke-')
            ->setCellValue('L1', 'Alamat')
            ->setCellValue('M1', 'RT/RW')
            ->setCellValue('N1', 'Kelurahan')
            ->setCellValue('O1', 'Kecamatan')
            ->setCellValue('P1', 'Kabupaten / Kota')
            ->setCellValue('Q1', 'Berat Badan')
            ->setCellValue('R1', 'Tinggi Badan')
            ->setCellValue('S1', 'Golongan Darah')
            ->setCellValue('T1', 'Asal SD/MI')
            ->setCellValue('U1', 'Asal SMP/MTs')
            ->setCellValue('V1', 'Ukuran Seragam')
            ->setCellValue('W1', 'Kelas')
            ->setCellValue('X1', 'Jurusan')
            ->setCellValue('Y1', 'Status Batal')
            ->setCellValue('Z1', 'Total Pengembalian Batal')
            ->setCellValue('AA1', 'Alasan Pembatalan')
            ->setCellValue('AB1', 'Status Kelulusan')
            ->setCellValue('AC1', 'Status Lunas')
            ->setCellValue('AD1', 'Biaya Pendidikan')
            ->setCellValue('AE1', 'Biaya Pengembangan')
            ->setCellValue('AF1', 'Total Wajib Bayar')
            ->setCellValue('AG1', 'Diskon Khusus')
            ->setCellValue('AH1', 'Nominal Diskon Khusus')
            ->setCellValue('AI1', 'Diskon Gelombang')
            ->setCellValue('AJ1', 'Total biaya setelah diskon')
            ->setCellValue('AK1', 'Nominal Sudah Bayar')
            ->setCellValue('AL1', 'Nominal Sisa Bayar')
            ->setCellValue('AM1', 'Nominal Kelebihan Bayar')
            ->setCellValue('AN1', 'Catatan Kelebihan Bayar')
            ->setCellValue('AO1', 'Nama Referensi')
            ->setCellValue('AP1', 'No Hp Referensi')
            ->setCellValue('AQ1', 'Nama Ayah')
            ->setCellValue('AR1', 'Tempat Tgl Lahir Ayah')
            ->setCellValue('AS1', 'Pendidikan Ayah')
            ->setCellValue('AT1', 'Pekerjaan Ayah')
            ->setCellValue('AU1', 'Penghasilan Ayah')
            ->setCellValue('AV1', 'No Hp Ayah')
            ->setCellValue('AW1', 'Alamat Ayah')
            ->setCellValue('AX1', 'Nama Ibu')
            ->setCellValue('AY1', 'Tempat Tgl Lahir Ibu')
            ->setCellValue('AZ1', 'Pendidikan Ibu')
            ->setCellValue('BA1', 'Pekerjaan Ibu')
            ->setCellValue('BB1', 'Penghasilan Ibu')
            ->setCellValue('BC1', 'No Hp Ibu')
            ->setCellValue('BD1', 'Alamat Ibu')
            ->setCellValue('BE1', 'Nama Wali')
            ->setCellValue('BF1', 'Tempat Tgl Lahir Wali')
            ->setCellValue('BG1', 'Pendidikan Wali')
            ->setCellValue('BH1', 'Pekerjaan Wali')
            ->setCellValue('BI1', 'Penghasilan Wali')
            ->setCellValue('BJ1', 'No Hp Wali')
            ->setCellValue('BK1', 'Alamat Wali')
            ->setCellValue('BL1', 'Surat Pernyataan ')
            ->setCellValue('BM1', 'Ijazah')
            ->setCellValue('BN1', 'Akte Kelahiran')
            ->setCellValue('BO1', 'Kartu Keluarga')
            ->setCellValue('BP1', 'KTP Ayah dan Ibu')
            ->setCellValue('BQ1', 'Kartu KIP)')
            ->setCellValue('BR1', 'Pasphoto Siswa ')
            ->setCellValue('BS1', 'Tanggal Entry');

        $column = 2;
        $row = 1;
        $currencyFormat = [
            'numberFormat' => [
                'formatCode' => '#,##0'
            ]
        ];
        $sheet = $spreadsheet->setActiveSheetIndex(0);
        // tulis data mobil ke cell
        foreach ($dataModel as $data) {
            $sheet->setCellValue('A' . $column, $data->no_pendaftaran)
                ->setCellValue('B' . $column, $data->gelombang)
                ->setCellValue('C' . $column, $data->nama_lengkap)
                ->setCellValue('D' . $column, $data->nama_panggilan)
                ->setCellValue('E' . $column, $data->nohp)
                ->setCellValue('F' . $column, $data->nisn)
                ->setCellValue('G' . $column, $data->jk)
                ->setCellValue('H' . $column, $data->agama)
                ->setCellValue('I' . $column, $data->tempat_lahir)
                ->setCellValue('J' . $column, $data->tanggal_lahir)
                ->setCellValue('K' . $column, $data->anak_ke)
                ->setCellValue('L' . $column, $data->alamat_peserta)
                ->setCellValue('M' . $column, $data->rt . '/' . $data->rw)
                ->setCellValue('N' . $column, $data->kelurahan)
                ->setCellValue('O' . $column, $data->kecamatan)
                ->setCellValue('P' . $column, $data->kab_kota)
                ->setCellValue('Q' . $column, $data->berat_badan)
                ->setCellValue('R' . $column, $data->tinggi_badan)
                ->setCellValue('S' . $column, $data->golongan_darah)
                ->setCellValue('T' . $column, $data->asal_sd)
                ->setCellValue('U' . $column, $data->asal_smp)
                ->setCellValue('V' . $column, $data->ukuran_seragam)
                ->setCellValue('W' . $column, $data->nama_kelas)
                ->setCellValue('X' . $column, $data->nama_jurusan)
                ->setCellValue('Y' . $column, $data->status_batal == 1 ? 'Ya' : 'Tidak')
                ->setCellValue('Z' . $column, \rupiahKan($data->total_pengembalian_batal))
                ->setCellValue('AA' . $column, $data->alasan_batal)
                ->setCellValue('AB' . $column, $data->status_kelulusan == 1 ? 'Ya' : 'Tidak')
                ->setCellValue('AC' . $column, $data->status_lunas == 1 ? 'Ya' : 'Tidak')
                ->setCellValue('AD' . $column, ($data->biaya_pendidikan - $data->biaya_attribut))
                ->setCellValue('AE' . $column, ($data->biaya_attribut))
                ->setCellValue('AF' . $column, ($data->biaya_pendidikan))
                ->setCellValue('AG' . $column, $data->nama_diskon)
                ->setCellValue('AH' . $column, ($data->nominal_diskon))
                ->setCellValue('AI' . $column, $data->diskon_biaya_pengembangan)
                ->setCellValue('AJ' . $column, ($data->biaya_pendidikan - $data->nominal_diskon - $data->diskon_biaya_pengembangan))
                ->setCellValue('AK' . $column, ($data->total_sudah_bayar))
                ->setCellValue('AL' . $column, ($data->total_wajib_bayar - $data->total_sudah_bayar - $data->nominal_diskon - $data->diskon_biaya_pengembangan))
                ->setCellValue('AM' . $column, ($data->kelebihan_bayar))
                ->setCellValue('AN' . $column, $data->catatan_kelebihan_bayar)
                ->setCellValue('AO' . $column, esc($data->referensi_nama))
                ->setCellValue('AP' . $column, esc($data->referensi_hp))
                
                
                 ->setCellValue('AQ' . $column, esc($data->nama_ayah))
                 ->setCellValue('AR' . $column, esc($data->ttl_ayah))
                 ->setCellValue('AS' . $column, esc($data->pendidikan_ayah))
                 ->setCellValue('AT' . $column, esc($data->pekerjaan_ayah))
                 ->setCellValue('AU' . $column, esc($data->penghasilan_ayah))
                 ->setCellValue('AV' . $column, esc($data->nohp_ayah))
                 ->setCellValue('AW' . $column, esc($data->alamat_ayah))
                 
                  ->setCellValue('AX' . $column, esc($data->nama_ibu))
                 ->setCellValue('AY' . $column, esc($data->ttl_ibu))
                 ->setCellValue('AZ' . $column, esc($data->pendidikan_ibu))
                 ->setCellValue('BA' . $column, esc($data->pekerjaan_ibu))
                 ->setCellValue('BB' . $column, esc($data->penghasilan_ibu))
                 ->setCellValue('BC' . $column, esc($data->nohp_ibu))
                 ->setCellValue('BD' . $column, esc($data->alamat_ibu))
                 
                  ->setCellValue('BE' . $column, esc($data->nama_wali))
                 ->setCellValue('BF' . $column, esc($data->ttl_wali))
                 ->setCellValue('BG' . $column, esc($data->pendidikan_wali))
                 ->setCellValue('BH' . $column, esc($data->pekerjaan_wali))
                 ->setCellValue('BI' . $column, esc($data->penghasilan_wali))
                 ->setCellValue('BJ' . $column, esc($data->nohp_wali))
                 ->setCellValue('BK' . $column, esc($data->alamat_wali))
                 
               
                 ->setCellValue('BL' . $column, $data->surat_pernyataan == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BM' . $column, $data->fc_izajah == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BN' . $column, $data->fc_akte_lahir == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BO' . $column, $data->fc_kk == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BP' . $column, $data->fc_ayah_ibu == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BQ' . $column, $data->fc_kip == 1 ? 'Sudah' : 'Belum')
                 ->setCellValue('BR' . $column, $data->pas_photo == 1 ? 'Sudah' : 'Belum')
               
                ->setCellValue('BS' . $column, tgl($data->created_at));
            $column++;
            $row++;
            $sheet->getStyle('Z' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AD' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AE' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AF' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AH' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AI' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AJ' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AK' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AL' . $row)->applyFromArray($currencyFormat);
            $sheet->getStyle('AM' . $row)->applyFromArray($currencyFormat);
        }
        // tulis dalam format .xlsx
        $sheet->getRowDimension(1)->setRowHeight(30);
        $styleRow = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
        ];
        $spreadsheet
            ->getActiveSheet()
            ->getStyle('A1:BS1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('ffcc00');

        $sheet->getStyle('A1:BS' . $row)
            ->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A1:BS' . $row)->applyFromArray($styleRow);
        foreach (range('A', 'Z') as $abjd) {
            $sheet->getColumnDimension($abjd)->setAutoSize(true);
            $sheet->getColumnDimension('A' . $abjd)->setAutoSize(true);
        }
        $writer = new Xlsx($spreadsheet);
        $fileName = 'Rekap Data PPDB - ' . date('YmdHis');

        // Redirect hasil generate xlsx ke web client
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $fileName . '.xlsx');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }
}
